<?php
/*
 * ----------------------------------------------------------------------
 *
 *                          Borlabs Cookie
 *                      developed by Borlabs
 *
 * ----------------------------------------------------------------------
 *
 * Copyright 2018 Borlabs - Benjamin A. Bornschein. All rights reserved.
 * This file may not be redistributed in whole or significant part.
 * Content of this file is protected by international copyright laws.
 *
 * ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 * @copyright Borlabs - Benjamin A. Bornschein, https://borlabs.io
 * @author Benjamin A. Bornschein, Borlabs ben@borlabs.io
 *
 */

namespace BorlabsCookie\Cookie\Frontend\BlockedContentTypes;

use BorlabsCookie\Cookie\Frontend\ContentBlocker;
use BorlabsCookie\Cookie\Frontend\JavaScript;

class Fallback
{
    private static $instance;

    public static function getInstance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __clone()
    {
    }

    private function __wakeup()
    {
    }

    /**
     * __construct function.
     *
     * @access protected
     * @return void
     */
    protected function __construct()
    {
        add_action('borlabsCookie/bct/edit_template/default', [$this, 'additionalSettingsTemplate']);
    }

    /**
     * getDefault function.
     *
     * @access public
     * @return void
     */
    public function getDefault()
    {
        $data = [
            'typeId'=>'default',
            'name'=>_x('Default', 'Blocked Content Type Name', 'borlabs-cookie'),
            'description'=>_x('The <strong>Default</strong> Blocked Content Type is a special type that is always used when no specific Blocked Content Type was found.<br>Therefore it is not possible to use the <strong>Unblock all</strong> feature.', 'Blocked Content Type Description', 'borlabs-cookie'),
            'hosts'=>[],
            'previewHTML'=>'<div class="borlabs-cookie-bct-default">
    <p>'._x('Click on the button below to load the content of %%name%%.', 'Blocked Content Types - Fallback', 'borlabs-cookie').'<br>
    <a role="button" data-borlabs-cookie-unblock>'._x('Load content', 'Blocked Content Types', 'borlabs-cookie').'</a></p>
</div>',
            'globalJS'=>'',
            'initJS'=>'',
            'settings'=>[],
            'status'=>true,
            'undeleteable'=>true,
        ];

        return $data;
    }

    /**
     * modify function.
     *
     * @access public
     * @param mixed $id
     * @param mixed $content
     * @return void
     */
    public function modify($id, $content)
    {
        // Get settings of the Blocked Content Type
        $bctData = ContentBlocker::getInstance()->getDataOfBlockedContentType('default');

        // Make Iframe responsive
        if (!empty($bctData['settings']['responsiveIframe'])) {

            $content = '<div class="borlabs-cookie-responsive-iframe-wrapper">'.$content.'</div>';

            JavaScript::getInstance()->addBlockedContent('default', $id, $content);
        }

        // Get the title which was maybe set via title-attribute in a shortcode
        $title = ContentBlocker::getInstance()->getCurrentTitle();

        // If no title was set use the host as title
        if (empty($title)) {
            $title = parse_url(ContentBlocker::getInstance()->getCurrentURL(), PHP_URL_HOST);
        }

        // Replace text variables
        $bctData['previewHTML'] = str_replace('%%name%%', $title, $bctData['previewHTML']);

        return $bctData['previewHTML'];
    }

    /**
     * additionalSettingsTemplate function.
     *
     * @access public
     * @param mixed $data
     * @return void
     */
    public function additionalSettingsTemplate($data)
    {
        $checkboxResponsiveIframe = !empty($data->settings['responsiveIframe']) ? ' checked' : '';
        ?>
        <div class="form-group">
            <div class="form-title"><?php _ex('Responsive Iframe', 'Setting title', 'borlabs-cookie'); ?></div>
            <div class="form-field">
                <label for="responsiveIframe">
                    <input<?php echo $checkboxResponsiveIframe; ?> type="checkbox" name="settings[responsiveIframe]" id="responsiveIframe" value="1"> <span class="option-title"><?php _ex('Activate', 'Setting checkbox', 'borlabs-cookie'); ?></span>
                </label>
                <span class="description"><?php _ex('The width and height will be replaced to get the iframe responsive.', 'Setting description', 'borlabs-cookie'); ?></span>
            </div>
        </div>
        <?php
    }
}
