<?php
/*
 * ----------------------------------------------------------------------
 *
 *                          Borlabs Cookie
 *                      developed by Borlabs
 *
 * ----------------------------------------------------------------------
 *
 * Copyright 2018 Borlabs - Benjamin A. Bornschein. All rights reserved.
 * This file may not be redistributed in whole or significant part.
 * Content of this file is protected by international copyright laws.
 *
 * ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 * @copyright Borlabs - Benjamin A. Bornschein, https://borlabs.io
 * @author Benjamin A. Bornschein, Borlabs ben@borlabs.io
 *
 */

namespace BorlabsCookie\Cookie\Frontend;

use BorlabsCookie\Cookie\Config;
use BorlabsCookie\Cookie\Multilanguage;

class Style
{
    private static $instance;

    public static function getInstance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __clone()
    {
    }

    private function __wakeup()
    {
    }

    protected function __construct()
    {
    }

    public function register()
    {
        // Avoid cached styles
        $styleVersion = get_option('BorlabsCookieStyleVersion_'.Multilanguage::getInstance()->getCurrentLanguageCode(), 1);

        $contentURL = content_url();

        // If CSS does not exist, try fallback
        if (file_exists(WP_CONTENT_DIR.'/cache/borlabs_cookie/borlabs-cookie_'.get_current_blog_id().'_'.Multilanguage::getInstance()->getCurrentLanguageCode().'.css')) {
            wp_enqueue_style('borlabs-cookie', $contentURL.'/cache/borlabs_cookie/borlabs-cookie_'.get_current_blog_id().'_'.Multilanguage::getInstance()->getCurrentLanguageCode().'.css', [], BORLABS_COOKIE_VERSION.'-'.$styleVersion);
        } else {

            // Fallback
            $styles = [
                'stylingPrimaryBackgroundColor'=>Config::getInstance()->get('stylingPrimaryBackgroundColor'),
                'stylingSecondaryBackgroundColor'=>Config::getInstance()->get('stylingSecondaryBackgroundColor'),
                'stylingTextColor'=>Config::getInstance()->get('stylingTextColor'),
                'stylingLinkColor'=>Config::getInstance()->get('stylingLinkColor'),
                'stylingSuccessMessageColor'=>Config::getInstance()->get('stylingSuccessMessageColor'),
                'stylingCookieOptionBorderColor'=>Config::getInstance()->get('stylingCookieOptionBorderColor'),

                'stylingCookieOptionBackgroundColor'=>Config::getInstance()->get('stylingCookieOptionBackgroundColor'),
                'stylingCookieOptionBackgroundColorHover'=>Config::getInstance()->get('stylingCookieOptionBackgroundColorHover'),
                'stylingCookieOptionTextColor'=>Config::getInstance()->get('stylingCookieOptionTextColor'),
                'stylingCookieOptionTextColorHover'=>Config::getInstance()->get('stylingCookieOptionTextColorHover'),

                'stylingCookieOptionBackgroundColor2'=>Config::getInstance()->get('stylingCookieOptionBackgroundColor2'),
                'stylingCookieOptionBackgroundColorHover2'=>Config::getInstance()->get('stylingCookieOptionBackgroundColorHover2'),
                'stylingCookieOptionTextColor2'=>Config::getInstance()->get('stylingCookieOptionTextColor2'),
                'stylingCookieOptionTextColorHover2'=>Config::getInstance()->get('stylingCookieOptionTextColorHover2'),

                'stylingCookieOptionBackgroundColor3'=>Config::getInstance()->get('stylingCookieOptionBackgroundColor3'),
                'stylingCookieOptionBackgroundColorHover3'=>Config::getInstance()->get('stylingCookieOptionBackgroundColorHover3'),
                'stylingCookieOptionTextColor3'=>Config::getInstance()->get('stylingCookieOptionTextColor3'),
                'stylingCookieOptionTextColorHover3'=>Config::getInstance()->get('stylingCookieOptionTextColorHover3'),

                'stylingBlockedContentBackgroundColor'=>Config::getInstance()->get('stylingBlockedContentBackgroundColor'),
                'stylingBlockedContentTextColor'=>Config::getInstance()->get('stylingBlockedContentTextColor'),
                'stylingBlockedContentButtonBackgroundColor'=>Config::getInstance()->get('stylingBlockedContentButtonBackgroundColor'),
                'stylingBlockedContentButtonBackgroundColorHover'=>Config::getInstance()->get('stylingBlockedContentButtonBackgroundColorHover'),
                'stylingBlockedContentButtonTextColor'=>Config::getInstance()->get('stylingBlockedContentButtonTextColor'),
                'stylingBlockedContentButtonTextColorHover'=>Config::getInstance()->get('stylingBlockedContentButtonTextColorHover'),
                'stylingBlockedContentSuccessMessage'=>Config::getInstance()->get('stylingBlockedContentSuccessMessage'),
            ];

            $inlineCSS = \BorlabsCookie\Cookie\Backend\Settings::getInstance()->getFinalCustomCSS($styles);

            wp_enqueue_style('borlabs-cookie', BORLABS_COOKIE_PLUGIN_URL.'css/borlabs-cookie.css', [], BORLABS_COOKIE_VERSION.'-'.$styleVersion);
            wp_add_inline_style('borlabs-cookie', $inlineCSS);
        }
    }
}