<?php
/*
 * ----------------------------------------------------------------------
 *
 *                          Borlabs Cookie
 *                      developed by Borlabs
 *
 * ----------------------------------------------------------------------
 *
 * Copyright 2018 Borlabs - Benjamin A. Bornschein. All rights reserved.
 * This file may not be redistributed in whole or significant part.
 * Content of this file is protected by international copyright laws.
 *
 * ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 * @copyright Borlabs - Benjamin A. Bornschein, https://borlabs.io
 * @author Benjamin A. Bornschein, Borlabs ben@borlabs.io
 *
 */

namespace BorlabsCookie\Cookie;

class Upgrade
{

    private static $instance;

    private $versionUpgrades = [
        'upgradeVersion_0_8' => '0.8',
        'upgradeVersion_1_0' => '1.0',
        'upgradeVersion_1_0_1' => '1.0.1',
        'upgradeVersion_1_1' => '1.1',
        'upgradeVersion_1_2' => '1.2',
        'upgradeVersion_1_2_1' => '1.2.1',
        'upgradeVersion_1_3' => '1.3',
        'upgradeVersion_1_3_1' => '1.3.1',
        'upgradeVersion_1_3_2' => '1.3.2',
        'upgradeVersion_1_3_3' => '1.3.3',
        'upgradeVersion_1_3_4' => '1.3.4',
        'upgradeVersion_1_4' => '1.4',
        'upgradeVersion_1_5' => '1.5',
        'upgradeVersion_1_5_1' => '1.5.1',
        'upgradeVersion_1_5_2' => '1.5.2',
        'upgradeVersion_1_5_3' => '1.5.3',
        'upgradeVersion_1_6' => '1.6',
        'upgradeVersion_1_6_1' => '1.6.1',
        'upgradeVersion_1_6_2' => '1.6.2',
        'upgradeVersion_1_6_3' => '1.6.3',
        'upgradeVersion_1_6_4' => '1.6.4',
        'upgradeVersion_1_6_5' => '1.6.5',
        'upgradeVersion_1_6_6' => '1.6.6',
        'upgradeVersion_1_7' => '1.7',
        'upgradeVersion_1_7_1' => '1.7.1',
        'upgradeVersion_1_7_2' => '1.7.2',
        'upgradeVersion_1_7_3' => '1.7.3',
        'upgradeVersion_1_7_4' => '1.7.4',
        'upgradeVersion_1_7_5' => '1.7.5',
        'upgradeVersion_1_7_6' => '1.7.6',
        'upgradeVersion_1_7_7' => '1.7.7',
        'upgradeVersion_1_7_8' => '1.7.8',
        'upgradeVersion_1_7_9' => '1.7.9',
        'upgradeVersion_1_7_10' => '1.7.10',
        'upgradeVersion_1_8' => '1.8',
        'upgradeVersion_1_8_1' => '1.8.1',
        'upgradeVersion_1_8_2' => '1.8.2',
        'upgradeVersion_1_9' => '1.9',
        'upgradeVersion_1_9_1' => '1.9.1',
        'upgradeVersion_1_9_2' => '1.9.2',
        'upgradeVersion_1_9_3' => '1.9.3',
        'upgradeVersion_1_9_4' => '1.9.4',
        'upgradeVersion_1_9_5' => '1.9.5',
        'upgradeVersion_1_9_6' => '1.9.6',
        'upgradeVersion_1_9_7' => '1.9.7',
        'upgradeVersion_1_9_8' => '1.9.8',
        'upgradeVersion_1_9_9' => '1.9.9',
    ];

    private $currentBlogId = '';

    public static function getInstance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __clone()
    {
    }

    private function __wakeup()
    {
    }

    public function __construct()
    {
    }

    /**
     * getVersionUpgrades function.
     *
     * @access public
     * @return void
     */
    public function getVersionUpgrades()
    {
        return $this->versionUpgrades;
    }

    public function upgradeVersion_0_8()
    {
        update_option('BorlabsCookieVersion', '0.8', 'no');
    }

    public function upgradeVersion_1_0()
    {
        update_option('BorlabsCookieVersion', '1.0', 'no');
    }

    public function upgradeVersion_1_0_1()
    {
        update_option('BorlabsCookieVersion', '1.0.1', 'no');
    }

    public function upgradeVersion_1_1()
    {
        update_option('BorlabsCookieVersion', '1.1', 'no');
    }

    public function upgradeVersion_1_2()
    {
        update_option('BorlabsCookieVersion', '1.2', 'no');
    }

    public function upgradeVersion_1_2_1()
    {
        update_option('BorlabsCookieVersion', '1.2.1', 'no');
    }

    public function upgradeVersion_1_3()
    {
        update_option('BorlabsCookieVersion', '1.3', 'no');
    }

    public function upgradeVersion_1_3_1()
    {
        update_option('BorlabsCookieVersion', '1.3.1', 'no');
    }

    public function upgradeVersion_1_3_2()
    {
        update_option('BorlabsCookieVersion', '1.3.2', 'no');
    }

    public function upgradeVersion_1_3_3()
    {
        update_option('BorlabsCookieVersion', '1.3.3', 'no');
    }

    public function upgradeVersion_1_3_4()
    {
        update_option('BorlabsCookieVersion', '1.3.4', 'no');
    }

    public function upgradeVersion_1_4()
    {
        update_option('BorlabsCookieVersion', '1.4', 'no');
    }

    public function upgradeVersion_1_5()
    {
        global $wpdb;

        $tableNameCookieLog = $wpdb->prefix.'borlabs_cookie_log';
        $charsetCollate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE IF NOT EXISTS ".$tableNameCookieLog." (
            `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
            `uid` varchar(35) NOT NULL DEFAULT '',
            `option` set('all','first-party','reject-all','no-selection','opted-out-ga','opted-out-fb') DEFAULT NULL,
            `stamp` datetime DEFAULT NULL,
            PRIMARY KEY (`log_id`),
            KEY `index_a` (`stamp`,`option`,`uid`),
            KEY `index_b` (`uid`,`stamp`,`option`)
        ) ".$charsetCollate.";";

        $wpdb->query($sql);

        update_option('BorlabsCookieVersion', '1.5', 'no');
    }

    public function upgradeVersion_1_5_1()
    {
        global $wpdb;

        delete_option('BorlabsCookieTableCreated');

        if (method_exists(\BorlabsCookie\Cookie\Install::getInstance(), 'checkIfTableExists')) {
            if (\BorlabsCookie\Cookie\Install::getInstance()->checkIfTableExists($wpdb->prefix.'borlabs_cookie_log') === false) {
                $this->upgradeVersion_1_5();
            }
        }

        update_option('BorlabsCookieVersion', '1.5.1', 'no');
    }

    public function upgradeVersion_1_5_2()
    {
        update_option('BorlabsCookieVersion', '1.5.2', 'no');
    }

    public function upgradeVersion_1_5_3()
    {
        update_option('BorlabsCookieVersion', '1.5.3', 'no');
    }

    public function upgradeVersion_1_6()
    {
        update_option('BorlabsCookieVersion', '1.6', 'no');
    }

    public function upgradeVersion_1_6_1()
    {
        update_option('BorlabsCookieVersion', '1.6.1', 'no');
    }

    public function upgradeVersion_1_6_2()
    {
        update_option('BorlabsCookieVersion', '1.6.2', 'no');
    }

    public function upgradeVersion_1_6_3()
    {
        update_option('BorlabsCookieVersion', '1.6.3', 'no');
    }

    public function upgradeVersion_1_6_4()
    {
        update_option('BorlabsCookieVersion', '1.6.4', 'no');
    }

    public function upgradeVersion_1_6_5()
    {
        update_option('BorlabsCookieVersion', '1.6.5', 'no');
    }

    public function upgradeVersion_1_6_6()
    {
        update_option('BorlabsCookieVersion', '1.6.6', 'no');
    }

    public function upgradeVersion_1_7()
    {
        // Add cache folder
        if (!file_exists(WP_CONTENT_DIR.'/cache')) {
            if (is_writable(WP_CONTENT_DIR)) {
                mkdir(WP_CONTENT_DIR.'/cache');
            }
        }

        if (!file_exists(WP_CONTENT_DIR.'/cache/borlabs_cookie')) {
            if (is_writable(WP_CONTENT_DIR.'/cache')) {
                mkdir(WP_CONTENT_DIR.'/cache/borlabs_cookie');
            }
        }

        // Set new styles
        // Update config
        $updatedConfig = get_option('BorlabsCookieConfig');

        $updatedConfig = array_merge($updatedConfig, [
            'stylingPrimaryBackgroundColor'=>'#f9f9f9',
            'stylingSecondaryBackgroundColor'=>'#eeeeee',
            'stylingTextColor'=>'#606569',
            'stylingLinkColor'=>'#288fe9',
            'stylingSuccessMessageColor'=>'#5eb930',
            'stylingCookieOptionBackgroundColor'=>'#ffffff',
            'stylingCookieOptionBackgroundColorHover'=>'#288fe9',
            'stylingCookieOptionBorderColor'=>'#f2f2f2',
            'stylingCookieOptionTextColor'=>'#606569',
            'stylingCookieOptionTextColorHover'=>'#ffffff',
            'stylingBlockedContentBackgroundColor'=>'#efefef',
            'stylingBlockedContentTextColor'=>'#666666',
            'stylingBlockedContentButtonBackgroundColor'=>'#288fe9',
            'stylingBlockedContentButtonBackgroundColorHover'=>'#2875e9',
            'stylingBlockedContentButtonTextColor'=>'#ffffff',
            'stylingBlockedContentButtonTextColorHover'=>'#ffffff',
            'stylingBlockedContentSuccessMessage'=>'#5eb930',
        ]);

        if (method_exists(\BorlabsCookie\Cookie\Backend\Settings::getInstance(), 'getFinalCustomCSS')) {
            $pluginPath = realpath(dirname(__FILE__).'/../../');

            if (file_exists(WP_CONTENT_DIR.'/cache/borlabs_cookie')) {

                $css = \BorlabsCookie\Cookie\Backend\Settings::getInstance()->getFinalCustomCSS($updatedConfig);

                $mainCSS = file_get_contents($pluginPath.'/css/borlabs-cookie.css');
                file_put_contents(WP_CONTENT_DIR.'/cache/borlabs_cookie/borlabs-cookie_'.get_current_blog_id().'.css', $css.$mainCSS);
            }
        }

        update_option('BorlabsCookieConfig', $updatedConfig, 'no');

        update_option('BorlabsCookieVersion', '1.7', 'no');
    }

    public function upgradeVersion_1_7_1()
    {
        update_option('BorlabsCookieVersion', '1.7.1', 'no');
    }

    public function upgradeVersion_1_7_2()
    {
        update_option('BorlabsCookieVersion', '1.7.2', 'no');
    }

    public function upgradeVersion_1_7_3()
    {
        update_option('BorlabsCookieVersion', '1.7.3', 'no');
    }

    public function upgradeVersion_1_7_4()
    {
        update_option('BorlabsCookieVersion', '1.7.4', 'no');
    }

    public function upgradeVersion_1_7_5()
    {
        update_option('BorlabsCookieVersion', '1.7.5', 'no');
    }

    public function upgradeVersion_1_7_6()
    {
        update_option('BorlabsCookieVersion', '1.7.6', 'no');
    }

    public function upgradeVersion_1_7_7()
    {
        update_option('BorlabsCookieVersion', '1.7.7', 'no');
    }

    public function upgradeVersion_1_7_8()
    {
        update_option('BorlabsCookieVersion', '1.7.8', 'no');
    }

    public function upgradeVersion_1_7_9()
    {
        update_option('BorlabsCookieVersion', '1.7.9', 'no');
    }

    public function upgradeVersion_1_7_10()
    {
        update_option('BorlabsCookieVersion', '1.7.10', 'no');
    }

    public function upgradeVersion_1_8()
    {
        // Update config
        $currentConfig = get_option('BorlabsCookieConfig');

        if (!empty($currentConfig) && is_array($currentConfig)) {

            $currentConfig['cookieBoxShow'] = $currentConfig['cookieBoxIsAlwaysDisplayed'] ? 'always' : 'automatic';

            $currentConfig['showCookieOption2'] = true;
            $currentConfig['showCookieOption3'] = $currentConfig['rejectThirdParty'];

            $currentConfig['stylingCookieOptionBackgroundColor2']       = $currentConfig['stylingCookieOptionBackgroundColor'];
            $currentConfig['stylingCookieOptionBackgroundColorHover2']  = $currentConfig['stylingCookieOptionBackgroundColorHover'];
            $currentConfig['stylingCookieOptionTextColor2']             = $currentConfig['stylingCookieOptionTextColor'];
            $currentConfig['stylingCookieOptionTextColorHover2']        = $currentConfig['stylingCookieOptionTextColorHover'];

            $currentConfig['stylingCookieOptionBackgroundColor3']       = $currentConfig['stylingCookieOptionBackgroundColor'];
            $currentConfig['stylingCookieOptionBackgroundColorHover3']  = $currentConfig['stylingCookieOptionBackgroundColorHover'];
            $currentConfig['stylingCookieOptionTextColor3']             = $currentConfig['stylingCookieOptionTextColor'];
            $currentConfig['stylingCookieOptionTextColorHover3']        = $currentConfig['stylingCookieOptionTextColorHover'];

            update_option('BorlabsCookieConfig', $currentConfig, 'no');
        }

        update_option('BorlabsCookieVersion', '1.8', 'no');
    }

    public function upgradeVersion_1_8_1()
    {
        global $wpdb;

        $tableName = $wpdb->prefix.'borlabs_cookie_log';

        // Check if key exists
        $checkKeyA = $wpdb->query("SHOW INDEXES FROM `".$tableName."` WHERE `Key_name`='index_a'");

        if (!$checkKeyA) {
            // Set key
            $sqlAddKey = "ALTER TABLE `".$tableName."` ADD KEY `index_a` (`stamp`,`option`,`uid`)";
            $wpdb->query($sqlAddKey);
        }

        $checkKeyB = $wpdb->query("SHOW INDEXES FROM `".$tableName."` WHERE `Key_name`='index_b'");

        if (!$checkKeyB) {
            // Set key
            $sqlAddKey = "ALTER TABLE `".$tableName."` ADD KEY `index_b` (`uid`,`stamp`,`option`)";
            $wpdb->query($sqlAddKey);
        }

        update_option('BorlabsCookieVersion', '1.8.1', 'no');
    }

    public function upgradeVersion_1_8_2()
    {
        update_option('BorlabsCookieVersion', '1.8.2', 'no');
    }

    public function upgradeVersion_1_9()
    {
        global $wpdb;

        $charsetCollate = $wpdb->get_charset_collate();

        if (method_exists(\BorlabsCookie\Cookie\Install::getInstance(), 'checkIfTableExists')) {

            $tableNameBlockedContentTypes = $wpdb->prefix.'borlabs_cookie_blocked_content_types';

            if (\BorlabsCookie\Cookie\Install::getInstance()->checkIfTableExists($tableNameBlockedContentTypes) === false) {
                $sql = "CREATE TABLE IF NOT EXISTS ".$tableNameBlockedContentTypes." (
                    `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
                    `type_id` varchar(35) NOT NULL DEFAULT '',
                    `language` varchar(14) NOT NULL DEFAULT '',
                    `name` varchar(100) NOT NULL DEFAULT '',
                    `description` text NOT NULL DEFAULT '',
                    `hosts` TEXT NOT NULL DEFAULT '',
                    `preview_html` TEXT NOT NULL DEFAULT '',
                    `global_js` TEXT NOT NULL DEFAULT '',
                    `init_js` TEXT NOT NULL DEFAULT '',
                    `settings` TEXT NOT NULL DEFAULT '',
                    `status` int(1) unsigned NOT NULL DEFAULT '0',
                    `undeletable` int(1) unsigned NOT NULL DEFAULT '0',
                    PRIMARY KEY (`id`),
                    UNIQUE KEY (`type_id`, `language`)
                ) ".$charsetCollate.";";

                $wpdb->query($sql);
            }
        }

        // Check if column was modified
        $tableNameCookieLog = $wpdb->prefix.'borlabs_cookie_log';

        $checkColumnType = $wpdb->get_results("
            SELECT
                `data_type`
            FROM
                `information_schema`.`columns`
            WHERE
                `table_schema`='".esc_sql($wpdb->dbname)."'
                AND
                `table_name`='".esc_sql($tableNameCookieLog)."'
                AND
                `column_name`='option'
        ");

        if (!empty($checkColumnType[0]->data_type) && $checkColumnType[0]->data_type != 'varchar') {
            $sql = "ALTER TABLE ".$tableNameCookieLog." MODIFY `option` varchar(35);";

            $wpdb->query($sql);

            // After a modification the index have to be added again
            $tableName = $wpdb->prefix.'borlabs_cookie_log';

            // Check if key exists
            $checkKeyA = $wpdb->query("SHOW INDEXES FROM `".$tableName."` WHERE `Key_name`='index_a'");

            if (!$checkKeyA) {
                // Set key
                $sqlAddKey = "ALTER TABLE `".$tableName."` ADD KEY `index_a` (`stamp`,`option`,`uid`)";
                $wpdb->query($sqlAddKey);
            }

            $checkKeyB = $wpdb->query("SHOW INDEXES FROM `".$tableName."` WHERE `Key_name`='index_b'");

            if (!$checkKeyB) {
                // Set key
                $sqlAddKey = "ALTER TABLE `".$tableName."` ADD KEY `index_b` (`uid`,`stamp`,`option`)";
                $wpdb->query($sqlAddKey);
            }
        }

        // Update config
        $originalConfig = get_option('BorlabsCookieConfig', false);
        $newConfig = $originalConfig;
        $translationUpdated = get_option('BorlabsCookieTranslationUpdated', false);
        $pluginPath = realpath(plugin_dir_path(__FILE__).'../../').'/';

        if (!empty($originalConfig) && empty($translationUpdated)) {

            // Update Multilanguage
            if (defined('ICL_LANGUAGE_CODE')) {

                $activeLanguages = apply_filters('wpml_active_languages', null, []);

                foreach ($activeLanguages as $languageData) {
                    if (!empty($languageData['code'])) {

                        $newConfig['textCookieOptionThirdParty']           = apply_filters('wpml_translate_single_string', $originalConfig['textCookieOptionThirdParty'], 'Borlabs Cookie - Text', 'Cookie options - Option 1: All cookies', $languageData['code']);
                        $newConfig['textCookieOptionFirstParty']           = apply_filters('wpml_translate_single_string', $originalConfig['textCookieOptionFirstParty'], 'Borlabs Cookie - Text', 'Cookie options - Option 2: First-party cookies', $languageData['code']);
                        $newConfig['textCookieOptionRejectThirdParty']     = apply_filters('wpml_translate_single_string', $originalConfig['textCookieOptionRejectThirdParty'], 'Borlabs Cookie - Text', 'Cookie options - Option 3: Reject all cookies', $languageData['code']);
                        $newConfig['textHelpHeadline']                     = apply_filters('wpml_translate_single_string', $originalConfig['textHelpHeadline'], 'Borlabs Cookie - Text', 'Help - Headline', $languageData['code']);
                        $newConfig['textHelpTop']                          = apply_filters('wpml_translate_single_string', $originalConfig['textHelpTop'], 'Borlabs Cookie - Text', 'Help - Help description top', $languageData['code']);
                        $newConfig['textHelpCookieOptionThirdParty']       = apply_filters('wpml_translate_single_string', $originalConfig['textHelpCookieOptionThirdParty'], 'Borlabs Cookie - Text', 'Help - Explanation of option 1', $languageData['code']);
                        $newConfig['textHelpCookieOptionFirstParty']       = apply_filters('wpml_translate_single_string', $originalConfig['textHelpCookieOptionFirstParty'], 'Borlabs Cookie - Text', 'Help - Explanation of option 2', $languageData['code']);
                        $newConfig['textHelpCookieOptionRejectThirdParty'] = apply_filters('wpml_translate_single_string', $originalConfig['textHelpCookieOptionRejectThirdParty'], 'Borlabs Cookie - Text', 'Help - Explanation of option 3', $languageData['code']);
                        $newConfig['textHelpBottom']                       = apply_filters('wpml_translate_single_string', $originalConfig['textHelpBottom'], 'Borlabs Cookie - Text', 'Help - Help description bottom', $languageData['code']);
                        $newConfig['textTitle']                            = apply_filters('wpml_translate_single_string', $originalConfig['textTitle'], 'Borlabs Cookie - Text', 'Additional texts - Title', $languageData['code']);
                        $newConfig['textExplanation']                      = apply_filters('wpml_translate_single_string', $originalConfig['textExplanation'], 'Borlabs Cookie - Text', 'Additional texts - Explanation text', $languageData['code']);
                        $newConfig['textInstruction']                      = apply_filters('wpml_translate_single_string', $originalConfig['textInstruction'], 'Borlabs Cookie - Text', 'Additional texts - Instruction text', $languageData['code']);
                        $newConfig['textHelpLink']                         = apply_filters('wpml_translate_single_string', $originalConfig['textHelpLink'], 'Borlabs Cookie - Text', 'Additional texts - Help link title', $languageData['code']);
                        $newConfig['textBackLink']                         = apply_filters('wpml_translate_single_string', $originalConfig['textBackLink'], 'Borlabs Cookie - Text', 'Additional texts - Back link title', $languageData['code']);
                        $newConfig['textCookieSettingSaved']               = apply_filters('wpml_translate_single_string', $originalConfig['textCookieSettingSaved'], 'Borlabs Cookie - Text', 'Additional texts - Message saved successfully', $languageData['code']);
                        $newConfig['textOptOut']                           = apply_filters('wpml_translate_single_string', $originalConfig['textOptOut'], 'Borlabs Cookie - Text', 'Additional texts - Opt-out text', $languageData['code']);
                        $newConfig['textOptOutSuccess']                    = apply_filters('wpml_translate_single_string', $originalConfig['textOptOutSuccess'], 'Borlabs Cookie - Text', 'Additional texts - Opt-out success text', $languageData['code']);
                        $newConfig['textLogColumnTitleUserAction']         = apply_filters('wpml_translate_single_string', $originalConfig['textLogColumnTitleUserAction'], 'Borlabs Cookie - Text', 'Column title: User action', $languageData['code']);
                        $newConfig['textLogColumnTitleStamp']              = apply_filters('wpml_translate_single_string', $originalConfig['textLogColumnTitleStamp'], 'Borlabs Cookie - Text', 'Column title: time stamp', $languageData['code']);
                        $newConfig['textLogOptionThirdParty']              = apply_filters('wpml_translate_single_string', $originalConfig['textLogOptionThirdParty'], 'Borlabs Cookie - Text', 'Option 1: All cookies', $languageData['code']);
                        $newConfig['textLogOptionFirstParty']              = apply_filters('wpml_translate_single_string', $originalConfig['textLogOptionFirstParty'], 'Borlabs Cookie - Text', 'Option 2: First-party cookies', $languageData['code']);
                        $newConfig['textLogOptionRejectAllCookies']        = apply_filters('wpml_translate_single_string', $originalConfig['textLogOptionRejectAllCookies'], 'Borlabs Cookie - Text', 'Option 3: Reject all cookies', $languageData['code']);
                        $newConfig['textLogOptionNoSelection']             = apply_filters('wpml_translate_single_string', $originalConfig['textLogOptionNoSelection'], 'Borlabs Cookie - Text', 'Option: No selection', $languageData['code']);
                        $newConfig['textLogOptOutGoogleAnalytics']         = apply_filters('wpml_translate_single_string', $originalConfig['textLogOptOutGoogleAnalytics'], 'Borlabs Cookie - Text', 'Opted-out Google Analytics', $languageData['code']);
                        $newConfig['textLogOptOutFacebookPixel']           = apply_filters('wpml_translate_single_string', $originalConfig['textLogOptOutFacebookPixel'], 'Borlabs Cookie - Text', 'Opted-out Facebook Pixel', $languageData['code']);

                        if ($languageData['code'] === 'de') {
                            // Load german language pack
                            load_textdomain('borlabs-cookie', $pluginPath.'languages/borlabs-cookie-de_DE.mo');
                        } else {
                            // Load unload language pack
                            unload_textdomain('borlabs-cookie');
                        }

                        // Add default Blocked Content Types
                        if (method_exists(\BorlabsCookie\Cookie\Backend\BlockedContentTypes::getInstance(), 'checkAndRestoreDefaults')) {
                            \BorlabsCookie\Cookie\Backend\BlockedContentTypes::getInstance()->checkAndRestoreDefaults($languageData['code']);
                        }

                        update_option('BorlabsCookieConfig_'.$languageData['code'], $newConfig, 'no');
                    }
                }
            } else {

                $currentLanguage = substr(get_option('WPLANG', 'en_US'), 0, 2);

                update_option('BorlabsCookieConfig_'.$currentLanguage, $newConfig, 'no');

                if ($currentLanguage === 'de') {
                    // Load german language pack
                    load_textdomain('borlabs-cookie', $pluginPath.'languages/borlabs-cookie-de_DE.mo');
                } else {
                    // Load unload language pack
                    unload_textdomain('borlabs-cookie');
                }

                // Add default Blocked Content Types
                if (method_exists(\BorlabsCookie\Cookie\Backend\BlockedContentTypes::getInstance(), 'checkAndRestoreDefaults')) {
                    \BorlabsCookie\Cookie\Backend\BlockedContentTypes::getInstance()->checkAndRestoreDefaults($currentLanguage);
                }
            }

            update_option('BorlabsCookieTranslationUpdated', true, 'no');
        }

        update_option('BorlabsCookieVersion', '1.9', 'no');
    }

    public function upgradeVersion_1_9_1()
    {
        update_option('BorlabsCookieVersion', '1.9.1', 'no');
    }

    public function upgradeVersion_1_9_2()
    {
        update_option('BorlabsCookieVersion', '1.9.2', 'no');
    }

    public function upgradeVersion_1_9_3()
    {
        update_option('BorlabsCookieVersion', '1.9.3', 'no');
    }

    public function upgradeVersion_1_9_4()
    {
        update_option('BorlabsCookieVersion', '1.9.4', 'no');
    }

    public function upgradeVersion_1_9_5()
    {
        update_option('BorlabsCookieVersion', '1.9.5', 'no');
    }

    public function upgradeVersion_1_9_6()
    {
        // Update license
        \BorlabsCookie\Cookie\Backend\License::getInstance()->validateLicense();

        update_option('BorlabsCookieVersion', '1.9.6', 'no');
    }

    public function upgradeVersion_1_9_7()
    {
        update_option('BorlabsCookieVersion', '1.9.7', 'no');
    }

    public function upgradeVersion_1_9_8()
    {
        update_option('BorlabsCookieVersion', '1.9.8', 'no');
    }

    public function upgradeVersion_1_9_9()
    {
        update_option('BorlabsCookieVersion', '1.9.9', 'no');
    }
}
